// file i/o
#include "stdinc.h"
#include "syscall.h"
#include "pg.h"
#include "string.h"
#include "main.h"
#include "pce.h"


// config file name
char* ConfigName(void)
{
    static char name[512];
    _strcpy(name,eRun.hue_path);
    _strcat(name,"hue.cfg");
    return name;
}

char* WramName(void)
{
    static char name[512];
    _strcpy(name,eRun.hue_path);
    _strcat(name,"wram.dat");
    return name;
}


//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
char* StateName(int num)
{
    static char name[512];
    char * p;
    _strcpy(name,eRun.cart_name);
    
    if((p=_strrchr(name,'.'))) { 
        *++p='s';*++p='a';
        if(num>0) { *++p=0x30+(num%10); }
        else      { *++p='v'; }
    }

    return name;
}


// @PSPEŐݒulႤ...
static int _of(char flag)
{
    if(flag=='w') {
        if(pgPSP()) {
          return O_CREAT | O_TRUNC | O_WRONLY;
        }
        return O_CREAT | O_TRUNC | O_RDWR ;
    }

    return O_RDONLY;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
void saveWRAM(void)
{
    int fd ;
    char * name = WramName();

    if((fd = sceIoOpen(name,_of('w'),0777))>=0) {
        sceIoWrite(fd,WRAM,0x2000);
        sceIoClose(fd);
    }
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
void loadWRAM(void)
{
    int fd;
    char *name=WramName();
    if((fd = sceIoOpen(name,_of('r'),0777))>=0) {
        sceIoRead(fd,WRAM,0x2000);
        sceIoClose(fd);
    }
}


#define COMP_SIGNATURE    0x00010004 // ݊mۗp
#define NOCD_SIGNATURE    0x00010060
#define INCD_SIGNATURE    0x80010060

extern void bank_set(byte P,byte V);

int SaveState(int num)
{
    int fd ;
    char * name = StateName(num);
	DWORD ver;
    int flag=0;

    if(!pgPSP()) { flag=O_CREAT|O_TRUNC|O_RDWR  ; }
    else         { flag=O_CREAT|O_TRUNC|O_WRONLY; }

    fd = sceIoOpen(name,flag,0777);
    if(fd>=0) {
#ifdef CDEMULATION
        if(CD_emulation==0) {
#endif//CDEMULATION
            ver = NOCD_SIGNATURE; // CDȂꍇ̃Z[uf[^
            sceIoWrite(fd,&ver     , sizeof(ver)       );
            sceIoWrite(fd,RAM      , sizeof(RAM)       );
            sceIoWrite(fd,VRAM     , sizeof(VRAM)      );
            sceIoWrite(fd,SPRAM    , sizeof(SPRAM)     );
            sceIoWrite(fd,huePal   , sizeof(huePal)    );
            sceIoWrite(fd,&scanline, sizeof(scanline)  );
            sceIoWrite(fd,&io      , sizeof(IO)        );
            sceIoWrite(fd,&M       , sizeof(M6502)     );
            if (populus)
              sceIoWrite(fd,PopRAM , sizeof(PopRAM));
            sceIoClose(fd);
            return 1;
#ifdef CDEMULATION
        } else {
            ver = INCD_SIGNATURE; // CDꍇ̃Z[uf[^
            sceIoWrite(fd,&ver     , sizeof(ver)       );
            sceIoWrite(fd,RAM      , sizeof(RAM)       );
            sceIoWrite(fd,VRAM     , sizeof(VRAM)      );
            sceIoWrite(fd,SPRAM    , sizeof(SPRAM)     );
            sceIoWrite(fd,huePal   , sizeof(huePal)    );
            sceIoWrite(fd,&scanline, sizeof(scanline)  );
            sceIoWrite(fd,&io      , sizeof(IO)        );
            sceIoWrite(fd,&M       , sizeof(M6502)     );
            sceIoWrite(fd,cd_extra_mem      , 0x10000);
            sceIoWrite(fd,cd_extra_super_mem, 0x30000);
            sceIoWrite(fd,cd_sector_buffer  , 0x2000 );
            sceIoClose(fd);
            return 1;
        }
        return -1;
#endif//CDEMULATION
    }

    return -1;
}



byte load_state[512*1024];
    
//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
int LoadState(int num)
{
    int i, fd;
	DWORD ver=0;
    char *name = StateName(num);

    fd = sceIoOpen(name,O_RDONLY,0777);

    if(fd>=0) {
        sceIoRead(fd,&ver,sizeof(ver));

        // ver 0.50̃t@Cǂޏꍇ
        if(ver==COMP_SIGNATURE) { 
            sceIoRead(fd,RAM      , sizeof(RAM)       );
            sceIoRead(fd,VRAM     , sizeof(VRAM)      );
            sceIoRead(fd,SPRAM    , sizeof(SPRAM)     );
            sceIoRead(fd,huePal   , sizeof(huePal)    );
            sceIoRead(fd,&scanline, sizeof(scanline)  );
            sceIoRead(fd,&io      , sizeof(IO_nocd)        );
            sceIoRead(fd,&M       , sizeof(M6502)     );
            if (populus)
              sceIoRead(fd,PopRAM , sizeof(PopRAM));
            sceIoClose(fd);
        }
        else if(ver==NOCD_SIGNATURE || ver==INCD_SIGNATURE) {
            sceIoRead(fd,RAM      , sizeof(RAM)       );
            sceIoRead(fd,VRAM     , sizeof(VRAM)      );
            sceIoRead(fd,SPRAM    , sizeof(SPRAM)     );
            sceIoRead(fd,huePal   , sizeof(huePal)    );
            sceIoRead(fd,&scanline, sizeof(scanline)  );
            sceIoRead(fd,&io      , sizeof(IO)        );
            sceIoRead(fd,&M       , sizeof(M6502)     );
            if (populus)
              sceIoRead(fd,PopRAM , sizeof(PopRAM));

#ifdef CDEMULATION
            if(CD_emulation && ver==INCD_SIGNATURE){
                sceIoWrite(fd,cd_extra_mem      , sizeof(cd_extra_mem));
                sceIoWrite(fd,cd_extra_super_mem, sizeof(cd_extra_super_mem));
                sceIoWrite(fd,cd_sector_buffer  , sizeof(cd_sector_buffer) );
            }
#endif// CDEMULATION

            sceIoClose(fd);
        }
        else {
            sceIoClose(fd);
            return -1;
        }
        
        for(i=0;i<8;i++)
          bank_set(i,M.MPR[i]);
        
        _memset(vchange,1,sizeof(vchange));
        
#ifdef USE_SPRITE_CACHE
        _memset(vchanges,1,sizeof(vchanges));
#endif //defined(USE_SPRITE_CACHE)
        return 1;
    }
    return -1;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
void clockDown(void)
{
    if(pgPSP()) {
        scePowerSetClockFrequency(222,222,111);
    }
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
void changeClock(void)
{
    if(pgPSP()) {
        pgWaitVn(5);
    
        switch(eConf.clock) {
          case 2:  scePowerSetClockFrequency(222,222,111); break;
          case 1:  scePowerSetClockFrequency(266,266,133); break;
          default: scePowerSetClockFrequency(333,333,166);
            eConf.clock = 0;
            break;
        }
        pgWaitVn(5);
    }
}


//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
int LoadConfig(void)
{
    char *name = ConfigName();
    int fd,len,ret=0;

    fd = sceIoOpen(name,O_RDONLY,0777);
    
    if(fd>=0) {
        len = sceIoRead(fd,&pConf,sizeof(pConf));
        sceIoClose(fd);
        if(len==sizeof(eConf)) {
            if(eConf.format==EMUCONFIG) {
                _memcpy(&eConf,&pConf,sizeof(pConf));
                ret=1;
            }
        }
    }

    return ret;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
int SaveConfig(void)
{
    int fd,len;
    int flag=0;
    char *name = ConfigName();

    if(!pgPSP()) { flag=O_CREAT|O_TRUNC|O_RDWR;   }
    else         { flag=O_CREAT|O_TRUNC|O_WRONLY; }

    if(_memcmp(&pConf,&eConf,sizeof(EmuConfig))!=0) {
        if((fd=sceIoOpen(name,flag,0777))>=0) {
            len = sceIoWrite(fd,&eConf,sizeof(eConf));
            sceIoClose(fd);
            return 1;
        }
    }
    return 0;
}

//
unsigned char REALROM[REALROM_SIZE];

#include "filer.h"
#include "zlibInterface.h"


// 錾
int funcUnzipCallback(int nCallbackId,
                      unsigned long ulExtractSize,
		      unsigned long ulCurrentPosition,
                      const void *pData,
                      unsigned long ulDataSize,
                      unsigned long ulUserData)
{
    const char *pszFileName;
    const unsigned char *pbData;

    switch(nCallbackId) {
      case UZCB_FIND_FILE:
        {
            DWORD * RomSz = (DWORD*)ulUserData;
            //mh_print(0,0,"UZCB_FIND_FILE",-1);
            //pgScreenFlipV();
            //pgWaitVn(100);
            
            pszFileName = (const char *)pData;
            
            if(getExtId(pszFileName)==EXT_PCE) {
                // WJ̈𒴂f[^̓pX`
                if(ulExtractSize>sizeof(REALROM)) {
                    return UZCBR_PASS;
                }
                
                *RomSz = ulExtractSize;
                return UZCBR_OK;
            }
        }
        return UZCBR_PASS;
        break;

      case UZCB_EXTRACT_PROGRESS:
        //mh_print(0,0,"UZCB_EXTRACT_PROGRESS",-1);
        //pgScreenFlipV();
        //pgWaitVn(100);
        
        pbData = (const unsigned char *)pData;

        _memcpy(&REALROM[ulCurrentPosition],pbData,ulDataSize);

        {
            int prog = (ulCurrentPosition+ulDataSize)*100 / ulExtractSize;
            //mh_print_dec(0,0,prog,RGB_RED);
            //mh_print_dec(0,10,ulCurrentPosition,-1);
            //mh_print_dec(0,20,ulDataSize,-1);
            pgScreenFlip();
            //pgWaitVn(100);
        }
        return UZCBR_OK;
        break;

      default: // unknown...
        /*
         ̃o[Wł͂ɂ͐΂ɂȂ(Ǝv)AFAILSAFÊ߂ɉ
         fobOR[hĂƗǂc
         */
        break; 
    }
    return UZCBR_CANCEL;
}


//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
int CartLoad(char *name)
{
    int fd;
    int ext = getExtId(name);

    switch(ext) {
      case EXT_PCE:
        if((fd = sceIoOpen(name,O_RDONLY,0777))>=0) {
            ROM_size = sceIoRead(fd,REALROM,REALROM_SIZE);
            sceIoClose(fd);
            ROM = REALROM + (ROM_size&0x00001fff);
            ROM_size&=~0x1fff;
            ROM_size=ROM_size/0x2000;
            _strcpy(eRun.cart_name,name);
            return 1;
        }
        break;

      case EXT_ZIP:
        {
            int extract;
            Unzip_setCallback(funcUnzipCallback);
            extract = Unzip_execExtract(name,&ROM_size);

            if(extract==UZEXR_OK) {
                ROM = REALROM + (ROM_size&0x00001fff);
                ROM_size&=~0x1fff;
                ROM_size=ROM_size/0x2000;
                return 1;
            } else {
                mh_print_dec(0,0,extract,-1);
                pgScreenFlipV();
                pgWaitVn(120);
            }
        }
        break;
        
      default:
      case EXT_UNKNOWN:
        return 0;
    }
    
    return 0;
}

